/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: InstallAdmin.cp,v 1.8 1999/05/08 10:24:39 wprice Exp $
____________________________________________________________________________*/

#include <Errors.h>
#include <Resources.h>

#define PGP_MACINTOSH		1

#include "pgpBase.h"
#include "MacResources.h"
#include "MacFiles.h"

#include "ExternCodeDefines.h"

static const ResType	kAdminType				=	'ADMN';
static const SInt16		ADMN_AdminPrefs			=	5001;
static const SInt16		ADMN_ClientPrefs		=	5002;
static const SInt16		ADMN_NetPrefs			=	5003;

static const ResType	kAdminConfiguredType	=	'PGPa';
static const SInt16		PGPa_Configured			=	0;

static const SInt32	msg_AdminPrefs				=	ADMN_AdminPrefs;
static const SInt32	msg_ClientPrefs				=	ADMN_ClientPrefs;
static const SInt32	msg_NetPrefs				=	ADMN_NetPrefs;
static const SInt32	msg_InstallIfAdmin			=	1;
static const SInt32	msg_InstallIfClient			=	2;
static const SInt32	msg_AddMarkerIfClient		=	3;

static const unsigned char *	kSecretMessage	=	"\pWhat's this for?";


	pascal void
main(
	ExternParmBlock *	eInfo)
{
	switch (eInfo->selector) {
		case kSelectorBeforeFile:
		{
			switch (eInfo->refCon) {
				case msg_InstallIfAdmin:
				case msg_InstallIfClient:
				{
					if (ResourceExists(kAdminType, ADMN_AdminPrefs, true)) {
						if (eInfo->refCon == msg_InstallIfAdmin) {
							eInfo->installFork = kDontInstallFile;
						}
					} else {
						if (eInfo->refCon == msg_InstallIfClient) {
							eInfo->installFork = kDontInstallFile;
						}
					}
				}
				break;
			}
		}
		break;
		
		
		case kSelectorAfterFile:
		{
			switch (eInfo->refCon) {
				case msg_AdminPrefs:
				case msg_ClientPrefs:
				case msg_NetPrefs:
				{
					OSStatus	err = resNotFound;
					FSSpec		theFile;
					
					// Create the FSSpec
					::FSMakeFSSpec(	eInfo->theFile.af_vRefNum,
									eInfo->theFile.af_DirID,
									eInfo->theFile.af_Name,
									&theFile);

					// Attempt to get the resource
					if (ResourceExists(kAdminType, eInfo->refCon, true)) {
						Handle		theAdminResource;
						SInt16		refNum;
						
						// Get a handle to the resource
						::SetResLoad(false);
						theAdminResource = ::Get1Resource(	kAdminType,
															eInfo->refCon);
						::SetResLoad(true);
						
						// Open the new file
						err = ::FSpOpenDF(	&theFile,
											fsRdWrPerm,
											&refNum);
						if (err == noErr) {
							SInt32		total = ::GetResourceSizeOnDisk(
													theAdminResource);
							SInt32		offset = 0;
							SInt32		blockSize = 1024;
							Ptr			theData = ::NewPtr(blockSize);
							
							err = MemError();
							if (err == noErr) {
								::SetEOF(	refNum,
											0);
								
								// Copy the resource to the file
								while (offset < total) {
									blockSize = ((total - offset) > 1024) ?
													1024 : (total - offset);
									::ReadPartialResource(	theAdminResource,
															offset,
															theData,
															blockSize);
									err = ResError();
									if (err == noErr) {
										offset += blockSize;
										err = ::FSWrite(	refNum,
															&blockSize,
															theData);
									}
									if (err != noErr) {
										break;
									}
								}
							}
							::DisposePtr(theData);
						}
						::FSClose(refNum);
					}
					
					// Delete the file if anything failed
					if (err != noErr) {
						::FSpDelete(&theFile);
					}
				}
				break;
				
				
				case msg_AddMarkerIfClient:
				{
					if (ResourceExists(kAdminType, ADMN_AdminPrefs, true)) {
						SInt16		refNum = -1;
						FSSpec		theFile;
						OSStatus	err;
						Handle		theMarker = nil;
						CInfoPBRec	catInfo;
						
						::FSMakeFSSpec(	eInfo->theFile.af_vRefNum,
										eInfo->theFile.af_DirID,
										eInfo->theFile.af_Name,
										&theFile);
						::SetResLoad(false);
						refNum = ::FSpOpenResFile(&theFile, fsWrPerm);
						::SetResLoad(true);
						err = ::ResError();
						if (err == noErr) {
							theMarker = ::NewHandle(0);
							err = ::MemError();
						}
					if (err == noErr) {
							::AddResource(	theMarker,
											kAdminConfiguredType,
											PGPa_Configured,
											"\p");
							theMarker = nil;
							err = ::ResError();
						}
						if (err == noErr) {
							::UpdateResFile(refNum);
							err = ::ResError();
						}
						if (theMarker != nil) {
							::DisposeHandle(theMarker);
						}
						if (refNum != -1) {
							::CloseResFile(refNum);
						}
						if (err == noErr) {
							err = FSpGetCatInfo(&theFile, &catInfo);
						}
						if (err == noErr) {
							cpbModificationDate(&catInfo) = 
								cpbCreationDate(&catInfo);
							FSpSetCatInfo(&theFile, &catInfo);
						}
					}
				}
				break;
			}
		}
		break;
	}
}
